IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Productos_Cobros') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Productos_Cobros
END
GO

CREATE PROCEDURE [dbo].[CPJ_Productos_Cobros] @pJsonRecibido VARCHAR(8000)

AS 
SET NOCOUNT ON

/*Parametros*/
DECLARE		@pId_Usuario			INT,
			@pFlagUsarTrans			TINYINT,
			@pModoDebug				TINYINT,
			@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
			@pPeriodoDesde			DATETIME,
			@pPeriodoHasta			DATETIME,
		    @pFlag_Liquidacion		TINYINT,
		    @pId_Periodo_Caja		INT,
		    @pFlag_FPago			TINYINT,
		    @pTipo_Cob				CHAR(1),		-- vacio = todos  M = Manual L=Lote
			@pFormato				VARCHAR(3),     --D  Detallado   F Resumen por Familia     CF  Resumen por Cobrador Familia  CFM  Resumen por Cob,Familia,Mes  P Producto  T Tipo/Categoria    CTA  Por cuenta y CC
			@pFlag_Filtrar_Fam		TINYINT,
			@pFlag_Inc_Fact_Periodo	TINYINT,		--Incluye lo facturado en el periodo y no este cobrado solo para formato  D
			@pFlag_Filtrar_Prod		TINYINT,
			@pFlag_No_Rec_Aplic		TINYINT,		-- Se agrega flag para validar si no se requiere Recibos de Aplicacion- 2021/08/12  0=Con Recibos de Aplica, 1= Sin Recibos de Aplica
			@pFlag_Filtrar_CC		TINYINT,
			@pId_Centro_Costo		VARCHAR(10),
            @pFlag_Filtrar_Caja		TINYINT,
			@pRegenerar_Archivo		CHAR(1),
			@pId_Familia            INT,
			@pId_Producto           VARCHAR(14),
			@pId_Cliente            INT,
			@pRegenarUltDias		INT

			


SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())

SET @pRegenarUltDias			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'RegenarUltDias')),0)
IF @pRegenarUltDias > 0 
BEGIN
	SET @pFechaDesde				= DATEADD(DAY, @pRegenarUltDias * -1 ,CONVERT(DATE,GETDATE()))
	SET @pFechaHasta				= GETDATE()
	PRINT @pFechaDesde
	PRINT @pFechaHasta
END



SET @pPeriodoDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'PeriodoDesde')),'')
SET @pPeriodoHasta				= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'PeriodoHasta'))
 IF @pPeriodoHasta IS NULL
    SET @pPeriodoHasta = (SELECT MAX(FECHA_QA) FROM CBTES_ITEMS)

SET	@pFlag_Liquidacion			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Liquidacion')), 0)
SET	@pId_Periodo_Caja			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Periodo_Caja')), 0)
SET	@pFlag_FPago				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_FPago')), 0)
SET	@pTipo_Cob					= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo_Cob')), '')
SET	@pFormato					= ISNULL(CONVERT(VARCHAR(3), dbo.CF_JSON_VALUE(@pJsonRecibido,'Formato')), 0)
SET	@pFlag_Filtrar_Fam			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Fam')), 0)
SET	@pFlag_Inc_Fact_Periodo		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Inc_Fact_Periodo')), 0)
SET	@pFlag_Filtrar_Prod			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Prod')), 0)
SET @pFlag_No_Rec_Aplic			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_No_Rec_Aplic')), 0)
SET @pFlag_Filtrar_CC			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_CC')), 0)
SET @pId_Centro_Costo	        = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Centro_Costo')), '')
SET @pFlag_Filtrar_Caja			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Caja')), 0)
SET @pRegenerar_Archivo			= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Regenerar_Archivo')),'S')
SET	@pId_Familia 		    	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Familia')), 0)
SET	@pId_Producto	            = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Producto')), '')
SET	@pId_Cliente 		    	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')), 0)
            

  CREATE TABLE #Trans (Id_Trans INT)

  CREATE TABLE #Coef_Pagos (Id_Trans Int
	,Imp_Total_Rec [decimal](20, 2)
	,Imp_Valores [decimal](20, 2)
	,Imp_PAGOS_APLI [decimal](20, 2)
	,Imp_Efe [decimal](20, 2)
	,Imp_Tar [decimal](20, 2)
	,Imp_CH3 [decimal](20, 2) 
	,Imp_CHP [decimal](20, 2)
	,Imp_DB [decimal](20, 2)
	,Imp_Fin [decimal](20, 2)
	,Imp_Aju [decimal](20, 2)
	,Coef_PAGOS_APLI decimal(14,5)
	,Coef_Efe decimal(14,5)
	,Coef_Tar decimal(14,5)
	,Coef_CH3 decimal(14,5) 
	,Coef_CHP decimal(14,5)
	,Coef_DB decimal(14,5)
	,Coef_Fin decimal(14,5)
	,Coef_Aju decimal(14,5)
	)

  DECLARE @Id_Producto 				VARCHAR(14)
		  ,@Id_Proveedor 			INT
		  ,@Razon_Social		 	VARCHAR(100)
		  ,@Cuit 					VARCHAR(13)
		  ,@Id_Iva 					CHAR(3)
		  ,@Id_Alias_Cta_Cont 		INT
		  ,@Id_Cta_Contable_H 		INT
		  ,@Porc_Comision_Prov 		DECIMAL(7,2) 
		  ,@Importe 				[decimal](20, 2)
		  ,@Importe_Credito 		[decimal](20, 2)
		  ,@Id_Tipo_Cbte 			CHAR(4) 
		  ,@Fecha 					DATETIME
		  ,@Imp_Prod_SIva  			[decimal](20, 2)
		  ,@Id_Trans 				INT
		  ,@Id_Cliente_Externo 		VARCHAR(14)
		  ,@Id_Cta_Banco 			INT
		  ,@Id_Cliente 				INT
		  ,@Total     				DECIMAL(20,2)
		  ,@Existe_Tag_Prod 		INT
		  ,@Existe_Tag_Fam 			INT
		  ,@Existe_Tag_Caja  		INT
		  ,@e_Tag_Prod				SMALLINT
		  ,@e_Tag_Prod_Familias		SMALLINT
		  ,@e_Tag_Prod_Cajas		SMALLINT

   DECLARE @Id_Trans_Rec INT 
		  ,@Id_Tipo_Val CHAR(3) 
		  ,@IMPORTE_Val [decimal](20, 2)
		  ,@EXISTE SMALLINT
		  ,@Imp_Total_Rec [decimal](20, 2)
		  ,@Tipo_val char(3)
		  ,@coef DECIMAL(10,5)
		  ,@coef_Apl DECIMAL(10,5)
		  ,@coef_Val DECIMAL(10,5)
		  ,@UltError SMALLINT

  SET @Fecha = (SELECT CAST(GETDATE() AS DATE))

  DECLARE @Sql		    VARCHAR(MAX)
  DECLARE @SqlSaldo	    VARCHAR(MAX)
  DECLARE @SqlSelect	VARCHAR(MAX)
  DECLARE @SqlInto	    VARCHAR(MAX)
  DECLARE @SqlFrom	    VARCHAR(MAX)
  DECLARE @SqlWhere  	VARCHAR(MAX)
  DECLARE @SqlGroup	    VARCHAR(MAX)

  SET @e_Tag_Prod = 90
  SET @Existe_Tag_Prod = 0 
  
  SET @e_Tag_Prod_Familias = 80
  SET @Existe_Tag_Fam = 0 
 
  SET @e_Tag_Prod_Cajas = 250
  SET @Existe_Tag_Caja = 0

  If @pId_Cliente > 0
     Set @pFormato = 'D'

  IF @pRegenerar_Archivo = 'S'
     BEGIN
        DELETE RPT_Productos_Cob_Detalle where Fecha_Rec >= @pFechaDesde  and Fecha_Rec < dateadd(dd,1,@pFechaHasta)
        SELECT * INTO #REPORTE FROM RPT_Productos_Cob_Detalle where 0=1
		DELETE #REPORTE

		/************************************************************* Calculo el importe positivo de lo aplicado del recibo ***************************************************************************************/
		IF @pModoDebug > 0   --1
		BEGIN
			PRINT @pModoDebug
		END

		SELECT A.ID_TRANS_D,SUM(A.IMPORTE) AS IMPORTE_REC
		   INTO #Tot_Recibos
		   FROM  CBTES C
		    JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte  AND T.Compromete_Recibos IN (1,-1)
			JOIN CBTES_APLICA A ON  A.ID_TRANS_D = C.ID_TRANS
		   WHERE C.ID_ESTADO_CBTE not in (0,3)
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 AND A.IMPORTE > 0
				 GROUP BY A.ID_TRANS_D 
 
		INSERT INTO #Tot_Recibos
			SELECT C.ID_TRANS,C.Imp_Total * T.Compromete_Factura
			   FROM  CBTES C
			     JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte 
				                    AND T.Compromete_Factura IN (1,-1) AND T.Flag_Items_Req <> 0
			   WHERE C.Id_Cond_Pago = 1
					 AND C.ID_ESTADO_CBTE not in (0,3)
					 AND C.FECHA >= @pFechaDesde 
					 AND C.FECHA < DATEADD(dd,1,@pFechaHasta)

		/************************************************************* Calculo el total de los valores del recibo ***************************************************************************************/

		IF @pModoDebug > 0   --2
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END

		SELECT C.ID_TRANS, C.FECHA, TR.IMPORTE_REC AS IMP_TOTAL,V.ID_TIPO_VAL,V.IMPORTE,CAST(V.Importe /TR.IMPORTE_REC AS DECIMAL(16,8)) AS COEF,V.Tarjeta_Cant_Cuotas
		   INTO #Valores_Rec
		   FROM CBTES C
		   JOIN CBTES_TIPOS T ON  C.Id_Tipo_Cbte = T.Id_Tipo_Cbte  AND ((T.COMPROMETE_FACTURA  IN (1,-1) AND C.Id_Cond_Pago = 1) OR T.Compromete_Recibos IN (1,-1))
		   JOIN #Tot_Recibos TR ON C.ID_TRANS = TR.ID_TRANS_D
           JOIN VALORES_MOV M ON C.ID_TRANS = M.ID_TRANS AND M.Renglon_Nro = 1
 		   JOIN VALORES V ON  M.ID_VALOR = V.ID_VALOR
		   WHERE C.ID_ESTADO_CBTE NOT IN (0,3)
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)

		UPDATE #Valores_Rec SET Importe = Importe * -1, Coef = Coef * -1 WHERE IMP_TOTAL < 0 


		/************************************************************* Calculo los pagos a cuenta ***************************************************************************************/
				 
		IF @pModoDebug > 0  --3
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END
		 
		SELECT C.ID_TRANS,C.FECHA,TR.IMPORTE_REC AS IMP_TOTAL,'ACUENTA' AS ID_PRODUCTO ,A.IMPORTE AS IMPORTE, CAST(A.IMPORTE/TR.IMPORTE_REC AS DECIMAL(16,8)) AS COEF,C.ID_CLIENTE 
		   INTO #ACuenta
		   FROM CBTES C
		   JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte AND T.Compromete_Recibos IN (1,-1)
		   JOIN CBTES_APLICA A ON A.ID_TRANS_D = C.ID_TRANS  AND A.Id_Trans = 0 AND A.IMPORTE <> 0
		   JOIN #Tot_Recibos TR ON C.ID_TRANS = TR.ID_TRANS_D
			 WHERE C.ID_ESTADO_CBTE NOT IN (0,3)
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)

		DECLARE @Pagos_a_Cuenta [decimal](20, 2)
		SET @Pagos_a_Cuenta = ISNULL((select sum(IMPORTE) FROM #ACuenta WHERE IMPORTE > 0 ),0)


		/************************************************************* Calculo las aplicaciones  ***************************************************************************************/

		IF @pModoDebug > 0  --4
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END

		SELECT C.ID_TRANS,C.FECHA,TR.IMPORTE_REC AS IMP_TOTAL,'APL' AS ID_TIPO_VAL,SUM(A.IMPORTE)*-1 AS IMPORTE, CONVERT(DECIMAL(16,8),0) AS COEF, 0 AS 'Tarjeta_Cant_Cuotas'
		   INTO #Recibos_Aplic
		   FROM CBTES C
		    JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte AND T.Compromete_Recibos IN (1,-1)
			JOIN #Tot_Recibos TR ON C.ID_TRANS = TR.ID_TRANS_D
		    JOIN CBTES_APLICA A ON A.ID_TRANS_D = C.ID_TRANS AND A.IMPORTE <> 0
			JOIN CBTES REC ON REC.Id_Trans = A.ID_TRANS
		    JOIN CBTES_TIPOS TNC ON  REC.Id_Tipo_Cbte = TNC.Id_Tipo_Cbte AND TNC.COMPROMETE_RECIBOS = 1
		   WHERE C.ID_ESTADO_CBTE <> 3
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
		   GROUP BY C.ID_TRANS,C.FECHA,TR.IMPORTE_REC


		/************************************************************* Notas de Credito tomadas en los recibos  ***************************************************************************************/

 		IF @pModoDebug > 0  --5
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END

		SELECT C.ID_TRANS, C.FECHA,R.IMPORTE_REC AS IMP_TOTAL,'N/C' AS ID_TIPO_VAL,SUM(A.IMPORTE)*-1 AS IMPORTE, CAST(0 AS DECIMAL(16,8)) AS COEF, 0 AS 'Tarjeta_Cant_Cuotas' 
		   INTO #NCREDITO
		   FROM CBTES C
		     JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte AND T.Compromete_Recibos IN (1,-1)
		     JOIN CBTES_APLICA A ON A.ID_TRANS_D = C.ID_TRANS AND A.IMPORTE <> 0
			 JOIN #Tot_Recibos R ON A.ID_TRANS_D = R.ID_TRANS_D
		     JOIN CBTES NC ON  A.Id_Trans = NC.ID_TRANS
		     JOIN CBTES_TIPOS TNC ON NC.Id_Tipo_Cbte = TNC.Id_Tipo_Cbte  AND TNC.COMPROMETE_FACTURA = -1
		   WHERE C.ID_ESTADO_CBTE <> 3
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 GROUP BY C.ID_TRANS, C.FECHA ,R.IMPORTE_REC

		/************************************************************* Calculo las retenciones  ***************************************************************************************/

		SELECT R.Id_Trans,SUM(R.IMPORTE) AS IMPORTE_RETEN
		   INTO #TOT_RETEN 
		   FROM  CBTES_RETEN R, #Tot_Recibos A
		   WHERE R.Id_Trans = A.Id_Trans_D
				 AND R.IMPORTE > 0
				 GROUP BY R.Id_Trans

		SELECT C.ID_TRANS, C.FECHA, R.IMPORTE_REC AS IMP_TOTAL,'RET' AS ID_TIPO_VAL,T.IMPORTE_RETEN AS IMPORTE
		   , CAST(0 AS DECIMAL(16,8)) AS COEF 
		   , 0 AS 'Tarjeta_Cant_Cuotas'
		   INTO #RETEN
		   FROM CBTES C, #TOT_RETEN T, #Tot_Recibos R
		   WHERE C.ID_TRANS  = T.ID_TRANS
				 AND R.ID_TRANS_D = C.ID_TRANS 
				 AND T.IMPORTE_RETEN <> 0

		/*************************************************************  ***************************************************************************************/

  		IF @pModoDebug > 0  --6
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END
 
		INSERT INTO #Valores_Rec
				SELECT * FROM #NCREDITO
		INSERT INTO #Valores_Rec
				SELECT * FROM #Recibos_Aplic
		INSERT INTO #Valores_Rec
				SELECT * FROM #RETEN

		UPDATE #Valores_Rec SET COEF = IMPORTE/IMP_TOTAL  FROM #Valores_Rec  

		IF @pModoDebug > 0  --7
		BEGIN
			SET @pModoDebug += 1
			PRINT 'Canceladas'
			PRINT @pModoDebug 
		END

		/*************************************************************  Facturas Canceladas ***************************************************************************************/

		
		SELECT C.ID_TRANS
				,R.IMPORTE_REC AS IMP_TOTAL
				,F.ID_TRANS AS ID_TRANS_FAC
				,A.IMPORTE  
				,CONVERT(DECIMAL(16,8),((abs(A.IMPORTE)/R.IMPORTE_REC)) ) AS COEF
				,C.Porc_Bonificacion
				,F.Imp_Total AS Tot_Fac
				,CASE ISNULL( F.Imp_Total,0) WHEN 0 THEN 0 
					ELSE CONVERT(DECIMAL(20,8),A.Importe / F.Imp_Total) 
				 END
					AS Coef_Fac_Aplic
		 INTO #Facturas
			FROM CBTES C
			JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte AND T.Compromete_Recibos IN (1,-1)
			JOIN CBTES_APLICA A ON A.ID_TRANS_D = C.ID_TRANS AND A.IMPORTE <> 0
			JOIN #Tot_Recibos R ON A.ID_TRANS_D = R.ID_TRANS_D AND R.IMPORTE_REC <> 0
			JOIN CBTES F ON A.Id_Trans = F.ID_TRANS
			JOIN CBTES_TIPOS TF ON F.Id_Tipo_Cbte = TF.Id_Tipo_Cbte	AND TF.COMPROMETE_FACTURA = 1
			WHERE C.ID_ESTADO_CBTE <> 3
					AND C.FECHA >= @pFechaDesde 
					AND C.FECHA < DATEADD(dd,1,@pFechaHasta)

		--	     SELECT * FROM Cbtes_Aplica WHERE Id_Trans_D = 13407289
			IF @pModoDebug > 0  --8
			BEGIN
				SET @pModoDebug += 1
				PRINT @pModoDebug 
			END

		/************************************************************* Agrego las facturas de contado  ***************************************************************************************/

		INSERT INTO #Facturas
			SELECT C.ID_TRANS
					,C.IMP_TOTAL
					,C.ID_TRANS AS ID_TRANS_FAC
					,C.IMP_TOTAL AS IMPORTE  
					,CONVERT(DECIMAL(16,8), 1 ) AS COEF
					,C.Porc_Bonificacion
					,C.Imp_Total AS Tot_Fac
					,CONVERT(DECIMAL(20,8),1) AS Coef_Fac_Aplic
				FROM CBTES C
				    JOIN CBTES_TIPOS T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte AND T.Compromete_Factura IN (1,-1) AND T.Flag_Items_Req <> 0 
			      WHERE C.ID_COND_PAGO = 1
						AND C.ID_ESTADO_CBTE NOT IN (0,3)
						AND C.FECHA >= @pFechaDesde 
						AND C.FECHA < DATEADD(dd,1,@pFechaHasta)


		/************************************************************* Items de Facturas Canceladas  ***************************************************************************************/


		SELECT I.ID_TRANS as Id_TRans_Fac,I.ITEM,I.ID_CLIENTE,I.ID_PRODUCTO,Descripcion_producto,I.Cantidad,
					CONVERT(DECIMAL(20,2), (I.Imp_Final * (1-F.Porc_Bonificacion/100) ) ) * T.Compromete_Factura AS IMP_FINAL_PRODUCTO 
					,F.COEF AS COEF
					,CONVERT(DECIMAL(20,8), (((i.Imp_Final * f.Coef_Fac_Aplic) / f.Importe ) ) )AS  Coef_Items
					,CONVERT(DECIMAL(20,4), ((R.IMPORTE_REC* (1-F.Porc_Bonificacion/100) * CONVERT(DECIMAL(20,8),((i.Imp_Final * f.Coef_Fac_Aplic) /f.Importe )) * F.COEF ))) AS Imp_Cobrado
					,F.Id_Trans
					,F.Importe * T.Compromete_Factura AS iMPORTE
			INTO #items
				FROM CBTES_ITEMS I
				 JOIN #Facturas F ON I.ID_TRANS = F.ID_TRANS_FAC
				 JOIN #Tot_Recibos R ON F.ID_TRANS = R.ID_TRANS_d
				 JOIN Cbtes C ON F.ID_TRANS_FAC = C.Id_Trans
				 JOIN Cbtes_Tipos T ON T.Id_Tipo_Cbte = C.Id_Tipo_Cbte
				WHERE I.Imp_Final <> 0


       UPDATE #items SET Imp_Cobrado = IMP_FINAL_PRODUCTO WHERE ABS(IMP_FINAL_PRODUCTO - Imp_Cobrado) < 1 

    --   select * from #items where id_trans in (1552338,
				--1552344,
				--1552351)

	   /************************************************************* PAgos Cuenta ***************************************************************************************/


		INSERT INTO  #items SELECT 0,0,A.ID_CLIENTE,'ACUENTA','PAGO A CUENTA',0,A.IMPORTE,A.COEF,A.COEF,A.IMPORTE,A.ID_TRANS,A.IMPORTE
				 FROM #ACuenta A

		IF @pModoDebug > 0 --9
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END

		   SELECT I.ID_TRANS,I.ITEM,i.ID_CLIENTE,i.ID_PRODUCTO,i.Descripcion_producto,I.Cantidad AS Cantidad_Prod,i.IMP_FINAL_PRODUCTO ,
				cast(i.coef_Items * 100 as DECIMAL(20,5)) AS Porc_Cobr_Fact,
				i.Imp_Cobrado,
				R.Id_Tipo_Val,
				cast(R.coef * 100 as DECIMAL(20,5)) AS Porc_TVal,
				CAST(i.Imp_Cobrado*r.coef AS DECIMAL(20,2)) AS IMP_VALOR
				,I.Id_Trans_Fac
				,R.FECHA 
				,R.IMP_TOTAL
				,i.coef 
				,I.Importe
				,R.Tarjeta_Cant_Cuotas
				INTO #RESUMEN 
				FROM #items i, #Valores_Rec R
				WHERE I.ID_TRANS = r.ID_TRANS
				AND I.Imp_Cobrado <> 0
				ORDER BY I.ID_TRANS 


		/*************************************************************  Detalle ***************************************************************************************/


		IF @pModoDebug > 0  --10
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END
		
		  INSERT INTO #REPORTE
				 SELECT  cast((i.Imp_Gravado * CF.Cotizacion) as [decimal](20, 2)) * TF.Compromete_Factura as Imp_Gravado_Item				--1
					,cast((i.Imp_Final * CF.Cotizacion) as [decimal](20, 2)) * TF.Compromete_Factura as Imp_Final_Item								--2
					,R.ID_TRANS_FAC as Id_Trans_Fac																		--3
					,cast((Cf.Imp_Gravado + CF.Imp_Gravado2 + Cf.Imp_Gravado3 + Cf.Imp_Exento) * CF.Cotizacion as [decimal](20, 2)) * TF.Compromete_Factura as Importe_Fac		--4
					,cast(Cf.Imp_total * CF.Cotizacion  as [decimal](20, 2)) * TF.Compromete_Factura as Imp_total_Fac							    --5
					,R.Id_trans as Id_Trans_Rec																			--6
					,cast(R.IMP_VALOR  as [decimal](20, 2))  as Importe_Aplicado											--7
					,i.Fecha_QA																							--8
					,i.Fecha_Venc																						--9
					,C.Id_cliente																						--10
					,C.Nombre_Fantasia																					--11
					,C.Id_Cliente_Externo																				--12
					,C.Razon_Social																						--13
					,C.Id_Tipo_Cli																						--14
					,dbo.CF_Cbte_Descrip(R.ID_TRANS_FAC) as Desc_Factura												--15
					,CR.Fecha																							--16
					,dbo.CF_Cbte_Descrip(R.ID_TRANS) as Desc_Recibo														--17
					,R.Fecha as Fecha_Rec																				--18
					,cast(R.IMP_TOTAL as [decimal](20, 2)) as Imp_Total_Rec												--19
					,CR.Id_Estado_Cbte																					--20
					,CR.Cotizacion as Cotizacion_Rec																	--21
					,CF.Cotizacion as Cotizacion_Fac																	--22
     				,CF.Porc_Bonificacion																				--23
					,CR.Id_Cobrador																						--24
					,R.Id_Producto																						--25
					,P.Descripcion_Detallada																			--26
					,CASE ISNULL(P.Id_Familia,0)	WHEN 0 THEN 65000 ELSE P.Id_Familia END																					--27
					,ISNULL(FP.Descripcion,'Pagos a Cuenta') as Descripcion_Familia										--28
 					,R.COEF * 100 as porc_aplicado																		--29
					,CAST(IMP_VALOR AS DECIMAL(20,2))  as Imp_Prod_CIva													--30
					,CAST(IMP_VALOR AS DECIMAL(20,2))  AS Imp_Prod_SIva												    --31
					,VE.DESCRIPCION AS Nombre_Cobrador																	--32
					,dbo.SF_Cli_Categ_Mes(i.Id_cliente, isnull(i.Fecha_QA,CR.Fecha)) as Id_Tipo_Cli_Ori					--33
					,CT.Descripcion AS Descripcion_Tipo_Cli																--34
					,isnull(c.id_cliente_ref,0) as id_cliente_ref														--35
					,cast(0 as [decimal](20, 2)) AS EFECTIVO																--36
					,cast(0 as [decimal](20, 2)) AS TARJETA																--37
					,cast(0 as [decimal](20, 2)) AS CHEQ_TER																--38
					,cast(0 as [decimal](20, 2)) AS CHEQ_PROP																--39
					,cast(0 as [decimal](20, 2)) AS DEBITO																	--40
					,cast(0 as [decimal](20, 2)) AS FINANC																	--41
					,cast(0 as [decimal](20, 2)) AS OTROS																	--42
					,cast(0 as [decimal](20, 2)) AS APLIC																	--43
					,CAST(IMP_VALOR AS DECIMAL(12,2)) AS Total_Pagos													--44
					,cast(0 as [decimal](20, 2)) AS Dif																	--45
					,i.Item as Item_Fac																					--46
 					,cast(R.coef as decimal(16,8)) AS Coef_Pago															--47 
					,ISNULL(CF.Id_Cond_Pago, 0) AS Id_Cond_Pago															--48  
					,ISNULL(CCP.Descripcion, '') AS Cond_Pago															--49  
					,cast(CF.Imp_Percep as [decimal](20, 2)) AS Imp_Total_Percep_Reten_Fac									--50  
					,cast(CR.Imp_Percep as [decimal](20, 2)) AS Imp_Total_Percep_Reten_Rec									--51  
					,CLFC.Nombre_Fantasia		AS FC_CL_Nombre_Fantasia												--52 
					,CLFC.Id_Cliente_Externo	AS FC_CL_Id_Cliente_Externo												--53 
					,CLFC.Razon_Social			AS FC_CL_Razon_Social													--54 
					,CLFC.Id_Tipo_Cli			AS FC_CL_Id_Tipo_Cli													--55 
					,CR.Id_Cobrador				AS CL_Id_Cobrador														--56 
					,CP.Id_Caja					AS Id_Caja																--57 
					,cast(I.Bonif as [decimal](20, 2)) AS Porc_Bonif_Item	                                            --58 
					,CASE I.Bonif WHEN 100 THEN 0
					         ELSE  												 
					             cast(((100 * I.Imp_Final) / (100-I.Bonif) * (R.Porc_Tval/100 )) as [decimal](20, 2)) * TF.Compromete_Factura 
					 END	AS Imp_Final_Item_Sin_Desc 	--59 
					,cast(((100 * I.Imp_Final) * (I.Bonif/100) * (R.Porc_Tval/100)) as [decimal](20, 2)) * TF.Compromete_Factura AS Imp_Bonif_Item				--60 
					,cast(R.Cantidad_Prod as [decimal](20, 2)) AS Cantidad_Prod															--61
					,P.Id_Alias_Cta_Cont AS Alias																		--62
					,P.Id_Centro_Costo   																		     	--63 
					,CONVERT(VARCHAR(20), TRR.Fecha_Mov, 120) AS Fac_Fecha_Mov											--64 
					,CONVERT(VARCHAR(20), TRF.Fecha_Mov, 120) AS Rec_Fecha_Mov                                          --65 
    				,cast(R.Importe as [decimal](20, 2)) As Importe                                                        --66 
 					,CM.Id_Periodo_Caja      AS Id_Periodo_Caja                                                         --67 
					,CR.id_tipo_Cbte         AS Id_Tipo_Cbte_Fac                                                        --68 
					,TF.Descripcion          AS Descripcion_Fac --69
					,I.Imp_Final * TF.Compromete_Factura --70
					,R.Porc_Cobr_Fact/100    AS COEF_ITEM      --71
					,R.Id_Tipo_Val  --72
					, (R.Porc_Tval/100) AS COEF_VAL  --73
					,cast(0 as [decimal](20, 2)) AS Ajustes	--74  												 
					,cast(0 as [decimal](20, 2)) AS Acuenta    --75
					,I.ITEM  --76
					,R.Tarjeta_Cant_Cuotas --77
			  FROM #RESUMEN R 
					LEFT JOIN Cbtes CR  ON R.ID_TRANS = CR.ID_TRANS                         ---ojjo
					LEFT JOIN Cbtes_Tipos TF ON CR.Id_Tipo_Cbte = TF.Id_Tipo_Cbte
					LEFT JOIN Transacciones TRF ON TRF.ID_TRANS = CR.ID_TRANS
					LEFT JOIN Clientes CLFC ON CR.Id_Cliente = CLFC.Id_Cliente
					LEFT JOIN Clientes_Tipos CT ON CLFC.Id_Tipo_Cli = CT.Id_Tipo_Cli
					LEFT JOIN Vendedores VE ON CR.Id_Cobrador = VE.Id_Vendedor
					LEFT JOIN CBTES_ITEMS I ON I.ID_TRANS = R.ID_TRANS_FAC AND I.ITEM = R.ITEM
					LEFT JOIN PRODUCTOS P ON R.ID_PRODUCTO  = P.ID_PRODUCTO
					LEFT JOIN PROD_FAMILIAS FP ON P.ID_FAMILIA  = FP.ID_FAMILIA
					LEFT JOIN CLIENTES C ON R.ID_CLIENTE  = C.ID_CLIENTE
					LEFT JOIN CBTES CF ON  CF.ID_TRANS  = R.ID_TRANS_FAC
					LEFT JOIN CBTES_COND_PAGO CCP ON CF.Id_Cond_Pago = CCP.Id_Cond_Pago
		  			LEFT JOIN Transacciones TRR ON TRR.ID_TRANS = R.ID_TRANS_FAC
					LEFT JOIN CAJAS_MOV CM ON CM.Id_Trans = R.Id_Trans
					LEFT JOIN CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = CM.Id_Periodo_Caja

		IF @pModoDebug > 0   --11
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END

		UPDATE #Reporte SET EFECTIVO = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'EFE' 
		UPDATE #Reporte SET TARJETA  = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'TAR'  
		UPDATE #Reporte SET CHEQ_TER = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'CH3'
		UPDATE #Reporte SET Cheq_Prop = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'CHP'  
		UPDATE #Reporte SET DEBITO = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'DB'  
		UPDATE #Reporte SET FINANC = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'FIN'
		UPDATE #Reporte SET APLIC = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val IN ('APL','N/C')
		UPDATE #Reporte SET AJUSTES = isnull(Imp_Prod_CIva,0) FROM #Reporte WHERE Id_Tipo_Val = 'AJU' 
		UPDATE #Reporte SET ACUENTA = Imp_Prod_CIva FROM #Reporte WHERE Id_PRODUCTO = 'ACUENTA'
		UPDATE #Reporte SET OTROS = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = ('RET')
		UPDATE #Reporte SET Total_Pagos = (Efectivo+Tarjeta+Cheq_Ter+Cheq_Prop+Debito+Financ+Ajustes+APLIC+OTROS) from #REPORTE

	    UPDATE #Reporte SET Id_Centro_Costo = '' WHERE Id_Centro_Costo IS NULL 

		IF @pModoDebug > 0   --12
		BEGIN
			SET @pModoDebug += 1
			PRINT @pModoDebug
		END

      IF @pRegenerar_Archivo = 'S'
	     INSERT INTO RPT_Productos_Cob_Detalle 
		        SELECT * FROM #Reporte

 END

  /************************************************************* Resultado ***************************************************************************************/


  ----VALIDAR FILTROS
  SELECT * INTO #PRODUCTOS FROM PRODUCTOS where 1=0
  IF @pId_Producto = ''
     BEGIN
		  IF @pFlag_Filtrar_Prod = 1
			SET @Existe_Tag_Prod = ISNULL( (SELECT COUNT(*) FROM TagFilePos_ TAG WHERE TAG.TBL = @e_Tag_Prod AND TAG.USR = @pId_Usuario) ,0)

		  IF @Existe_Tag_Prod > 0 and @pFlag_Filtrar_Prod = 1
	    	  BEGIN
				INSERT INTO #PRODUCTOS 
				SELECT * FROM PRODUCTOS P WHERE P.ID_PRODUCTO IN (SELECT Tag.Pos FROM TagFilePos_ TAG WHERE  TAG.TBL = @e_Tag_Prod AND TAG.USR = @pId_Usuario )
              END
			ELSE
			  BEGIN
				INSERT INTO #PRODUCTOS  SELECT * FROM PRODUCTOS 
				IF NOT EXISTS (SELECT 1 FROM PRODUCTOS WHERE Id_Producto = 'ACUENTA')
					INSERT INTO #PRODUCTOS  (Id_Producto,Descripcion_Detallada) VALUES ('ACUENTA','Pago a Cuenta')
			  END
	 END
	ELSE
	 BEGIN
	    INSERT INTO #PRODUCTOS  SELECT * FROM PRODUCTOS WHERE ID_PRODUCTO = @pId_Producto
	 END


  SELECT * INTO #FAMILIAS FROM PROD_FAMILIAS where 1=0
  IF @pId_Familia = 0
     BEGIN
       IF @pFlag_Filtrar_Fam = 1
          SET @Existe_Tag_Fam = ISNULL( (SELECT COUNT(*) FROM TagFile_ TAG WHERE TAG.TBL = @e_Tag_Prod_Familias AND TAG.USR = @pId_Usuario) ,0)

       IF @Existe_Tag_Fam > 0 and @pFlag_Filtrar_Fam = 1
	      INSERT INTO #FAMILIAS
			SELECT * FROM PROD_FAMILIAS P WHERE P.Id_Familia IN (SELECT Tag.Val FROM TagFile_ TAG WHERE  TAG.TBL = @e_Tag_Prod_Familias AND TAG.USR = @pId_Usuario )
		ELSE
		BEGIN
		  INSERT INTO #FAMILIAS  SELECT * FROM PROD_FAMILIAS
		  IF NOT EXISTS (SELECT 1 FROM PROD_FAMILIAS WHERE Id_Familia = 65000)
			 INSERT INTO #FAMILIAS (Id_Familia,Descripcion) VALUES (65000,'Pagos a Cuenta')
		END
     END
  ELSE
	 BEGIN
	    INSERT INTO #FAMILIAS  SELECT * FROM PROD_FAMILIAS WHERE Id_Familia = @pId_Familia
	 END	
	 

  SELECT * INTO #CAJAS_PERIODOS FROM Cajas_Periodos
   IF @pFlag_Filtrar_Caja = 1 
        DELETE #CAJAS_PERIODOS FROM #CAJAS_PERIODOS P WHERE P.Id_Periodo_Caja NOT IN (SELECT Tag.Val FROM TagFile_ TAG WHERE  TAG.TBL = @e_Tag_Prod_Cajas AND TAG.USR = @pId_Usuario )
 
---------------
  set @Total = (SELECT SUM(ISNULL(Imp_Prod_CIva,0)) FROM RPT_Productos_Cob_Detalle where FECHA_REC >= @pFechaDesde 
			          AND FECHA_REC < dateadd(dd,1,@pFechaHasta))
  
  IF UPPER(@pFormato) = 'D' OR @pFormato = ''
     IF @pId_Cliente > 0
		    SELECT R.*,P.Descripcion AS Cta, P.Nro_Cta_Contable, CC.Descripcion AS Centro_Costo,
			           REPLACE(REPLACE(REPLACE(REPLACE(LTRIM(RTRIM(Telefono)), CHAR(9), ''), CHAR(13), ''), CHAR(10), ''), ' ', '/') AS Telefono,
					   C.Email, C.Doc_Nro, C.Fecha_Nac,J.Descripcion AS Descripcion_Caja, CP.Id_Cajero, E.Apellido_Nombre, U.LastName AS Operador
				FROM RPT_Productos_Cob_Detalle R 
				 LEFT JOIN Pla_Ctas_Cuentas_Contables P ON P.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
		    	 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 JOIN Cajeros K ON K.Id_Cajero = CP.Id_Cajero
				 JOIN Empleados E ON E.Id_Empleado = K.Id_Empleado
				 JOIN Cajas J ON J.Id_Caja = CP.Id_Caja
				 JOIN CLIENTES C ON C.Id_Cliente = R.Id_cliente
				 JOIN Transacciones T ON T.Id_Trans = R.Id_Trans_Rec
				 JOIN Seg_User U ON T.Id_Usuario = U.No
				, Centro_Costos CC
				WHERE R.Id_Centro_Costo = CC.Id_Centro_Costo 
					  AND R.FECHA_REC >= @pFechaDesde 
			          AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
					  and R.Id_cliente = @pId_cliente
				ORDER BY  R.Fecha_Rec,R.Razon_Social,R.Id_Producto
		ELSE
		    SELECT R.*,P.Descripcion AS Cta, P.Nro_Cta_Contable, CC.Descripcion AS Centro_Costo,
			    REPLACE(REPLACE(REPLACE(REPLACE(LTRIM(RTRIM(Telefono)), CHAR(9), ''), CHAR(13), ''), CHAR(10), ''), ' ', '/') AS Telefono,
				C.Email, C.Doc_Nro, C.Fecha_Nac,J.Descripcion AS Descripcion_Caja, CP.Id_Cajero, E.Apellido_Nombre, U.LastName AS Operador
				FROM RPT_Productos_Cob_Detalle R 
				 LEFT JOIN Pla_Ctas_Cuentas_Contables P ON P.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
		    	 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 JOIN Cajeros K ON K.Id_Cajero = CP.Id_Cajero
				 JOIN Empleados E ON E.Id_Empleado = K.Id_Empleado
				 JOIN Cajas J ON J.Id_Caja = CP.Id_Caja
				 JOIN CLIENTES C ON C.Id_Cliente = R.Id_cliente
				 JOIN Transacciones T ON T.Id_Trans = R.Id_Trans_Rec
				 JOIN Seg_User U ON T.Id_Usuario = U.No
				, Centro_Costos CC
				WHERE R.Id_Centro_Costo = CC.Id_Centro_Costo 
					  AND R.FECHA_REC >= @pFechaDesde 
			          AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
				ORDER BY  R.Fecha_Rec,R.Razon_Social,R.Id_Producto			  

  IF UPPER(@pFormato) = 'P'
     SELECT R.Id_Producto,R.Descripcion_Detallada,Sum(ISNULL(R.Cantidad_Prod,0)) as Cantidad_Prod, SUM(r.Imp_Prod_CIva) AS Imp_Prod_CIva,
	        cast((SUM(R.Imp_Prod_CIva) / @Total * 100 ) as decimal(16,2)) AS Participacion 
			FROM RPT_Productos_Cob_Detalle R
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
		    WHERE R.FECHA_REC >= @pFechaDesde 
				  AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Producto, R.Descripcion_Detallada
			ORDER BY Participacion Desc,R.Descripcion_Detallada  

  IF UPPER(@pFormato) = 'F'
     SELECT R.Id_Familia, R.Descripcion_Familia,Sum(ISNULL(R.Cantidad_Prod,0)) as Cantidad_Prod, SUM(Imp_Prod_CIva) AS Imp_Prod_CIva,
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Familia, R.Descripcion_Familia
			ORDER BY Participacion Desc
			
  IF UPPER(@pFormato) = 'R'
     SELECT R.Fecha_Rec, R.Desc_Recibo,R.Id_Trans_Rec,R.Id_Cliente,R.Id_Cliente_Externo, R.Razon_Social , SUM(Imp_Prod_CIva) AS Imp_Prod_CIva,
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Fecha_Rec, R.Desc_Recibo,R.Id_Trans_Rec,R.Id_Cliente,R.Id_Cliente_Externo, R.Razon_Social 
			ORDER BY R.Fecha_Rec, R.Desc_Recibo

  IF UPPER(@pFormato) = 'CF'
	 SELECT R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador , SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R 
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador
			ORDER BY R.Nombre_Cobrador,Participacion Desc

  IF UPPER(@pFormato) = 'CFM'
	 SELECT R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador , 
			DATEPART(mm,R.Fecha_QA) AS Mes,DATEPART(YY,R.Fecha_QA) AS Anio,
			SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R 
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador,DATEPART(mm,R.Fecha_QA),DATEPART(YY,R.Fecha_QA)
			ORDER BY R.Nombre_Cobrador,R.Id_Cobrador,R.Descripcion_Familia,DATEPART(YY,R.Fecha_QA),DATEPART(mm,R.Fecha_QA)

  IF UPPER(@pFormato) = 'FPI'
	 SELECT R.Id_Familia, R.Descripcion_Familia,Sum(ISNULL(R.Cantidad_Prod,0)) as Cantidad_Prod,
			substring(convert(nvarchar(10),R.Fecha_QA,112),1,6)+'01' as Periodo,
			SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R 
				JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
	    	GROUP BY R.Id_Familia, R.Descripcion_Familia,substring(convert(nvarchar(10),R.Fecha_QA,112),1,6)+'01'
			ORDER BY R.Descripcion_Familia,substring(convert(nvarchar(10),R.Fecha_QA,112),1,6)+'01'


  IF UPPER(@pFormato) = 'T'
	 SELECT Id_Tipo_Cli_Ori, T.Descripcion  , SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja, Clientes_Tipos t
			WHERE T.Id_Tipo_Cli = R.Id_Tipo_Cli_Ori
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY Id_Tipo_Cli_Ori, T.Descripcion 
			ORDER BY Participacion Desc

  IF UPPER(@pFormato) = 'FP'
   
	 SELECT substring(convert(nvarchar(10),Fecha_Rec,112),1,6)+'01' as Fecha_Rec,sum(Efectivo) as Efectivo,sum(Tarjeta) as Tarjeta 
	        ,sum(Cheq_ter) as Cheq_ter,sum(CHEQ_PROP) as Cheq_Prop ,sum(DEBITO) as Debito 
			,sum(FINANC) as Financ ,sum(OTROS) as Otros,sum(AJUSTES) as Ajustes,sum(APLIC) as Aplic,sum(ACUENTA) as Acuenta, sum(Total_Pagos) as Total_Pagos
	 		FROM RPT_Productos_Cob_Detalle R
			   	 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 WHERE R.FECHA_REC >= @pFechaDesde 
				 AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY substring(convert(nvarchar(10),Fecha_Rec,112),1,6)+'01'

  IF UPPER(@pFormato) = 'S'
	 SELECT S.Id_Sector, ISNULL(S.Descripcion,'SIN SECTOR') AS Descripcion, COUNT(*) AS Cantidad, SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
				 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
                 JOIN Empresas_Sedes_Sectores S ON S.ID_SECTOR  = PR.ID_SECTOR
			WHERE  R.FECHA_REC >= @pFechaDesde 
				   AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY S.Id_Sector, S.Descripcion
			ORDER BY Participacion Desc

  IF UPPER(@pFormato) = 'CTA'
     BEGIN
		 SELECT R.Alias,C.Nro_Cta_Contable,C.Descripcion ,R.Id_Centro_Costo,CC.Descripcion AS Centro_Costo,SUM(Imp_Prod_CIva) AS Imp_Prod_CIva,
				 
				CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion 
				,SUM(APLIC) AS Aplicado
				,SUM(Imp_Prod_CIva) - SUM(APLIC) AS Tot_Sin_Aplic
				FROM RPT_Productos_Cob_Detalle R 
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 , Pla_Ctas_Cuentas_Contables C, Centro_Costos CC
				WHERE  C.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
				AND R.Id_Centro_Costo = CC.Id_Centro_Costo
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
				GROUP BY R.Alias,C.Nro_Cta_Contable,C.Descripcion ,R.Id_Centro_Costo,CC.Descripcion
				ORDER BY C.Nro_Cta_Contable,R.Id_Centro_Costo
     END


  IF UPPER(@pFormato) = 'CC'
     BEGIN
		 SELECT R.Id_Centro_Costo,CC.Descripcion AS Centro_Costo,SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
				CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion 
				FROM RPT_Productos_Cob_Detalle R 
				 JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				, Pla_Ctas_Cuentas_Contables C, Centro_Costos CC
				WHERE  C.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
				AND R.Id_Centro_Costo = CC.Id_Centro_Costo
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
				GROUP BY R.Id_Centro_Costo,CC.Descripcion
				ORDER BY CC.Descripcion
      END

 
  IF EXISTS(SELECT [name] FROM tempdb.sys.tables WHERE [name] = '#Reporte') 
		DROP TABLE #Reporte

  IF @pRegenerar_Archivo ='S'
     BEGIN
		  DROP TABLE #NCREDITO
		  DROP TABLE #Valores_Rec
		  DROP TABLE #Facturas
		  DROP TABLE #RESUMEN 
		  DROP TABLE #ITEMS
		  DROP TABLE #Recibos_Aplic
		  DROP TABLE #PRODUCTOS  
		  DROP TABLE #FAMILIAS 
		  DROP TABLE #CAJAS_PERIODOS  
		  DROP TABLE #RETEN 
		  DROP TABLE #TOT_RETEN 		
     END


/*


EXEC CPJ_Productos_Cobros '{"Id_Usuario":"-1"
,"Equate":"90"
,"FechaDesde":"20230510"
,"FechaHasta":"20230510"
,"Flag_Liquidacion":"0"
,"Flag_FPago":"0"
,"Tipo_Cob":"-"
,"Formato":"D"
,"Flag_Filtrar_Prod":"0"
,"Flag_Filtrar_Fam":"0"
,"Flag_Filtrar_Caja":"0"
,"Id_Familia":""
,"Id_Producto":""
,"Id_Cliente":""
,"Regenerar_Archivo":"S"
,"Flag_Inc_Fact_Periodo":"0"}' 


select * from TagFilePos_

delete TagFilePos_ where usr =-1


	"D" =>"Detallado" 
	,"F"=>"Agrupado por familia de productos"
	,"FPI" =>"Agrupado por familia \ Periodo Item"
	,"P"=>"Agrupado por producto"
	,"R" => "Agrupado por Recibo"
	,"CF"=>"Agrupado por cobrador y familia de productos"
	,"CFM"=>"Agrupado por cobrador, familia de productos y mes"
	,"FP" => "Agrupado por Forma de Pago"
	,"T" => "Agrupado por Tipo/Categoria"
	,"CC" => "Agrupado por Centro Costos"
	,"S" => "Agrupado por Sector"



*/